import sys

def resi_zadatak():
    # Brzo citanje ulaza
    podaci = sys.stdin.read().split()
    if not podaci:
        return
    
    n = int(podaci[0])
    tacke = []
    indeks = 1
    for _ in range(n):
        x = int(podaci[indeks])
        y = int(podaci[indeks+1])
        tacke.append((x, y))
        indeks += 2

    # 1. Pozdravi u trenutku t=0 (6 pozdrava po svakoj od N tacaka)
    ukupno_pozdrava = 6 * n

    # Recnici za brojanje tacaka sa istim invariantama
    iste_y_parnost_x = {}  # Za Sever-Jug susrete
    iste_x_parnost_y = {}  # Za Istok-Zapad susrete
    dijagonala_suma = {}   # Za Sever-Istok i Jug-Zapad susrete
    dijagonala_razlika = {} # Za Sever-Zapad i Jug-Istok susrete

    for x, y in tacke:
        # Invariante za horizontalne/vertikalne susrete
        k1 = (y, x % 2)
        iste_y_parnost_x[k1] = iste_y_parnost_x.get(k1, 0) + 1
        
        k2 = (x, y % 2)
        iste_x_parnost_y[k2] = iste_x_parnost_y.get(k2, 0) + 1
        
        # Invariante za dijagonalne susrete (x+y i y-x)
        k3 = x + y
        dijagonala_suma[k3] = dijagonala_suma.get(k3, 0) + 1
        
        k4 = y - x
        dijagonala_razlika[k4] = dijagonala_razlika.get(k4, 0) + 1

    # 2. Dodajemo susrete za t > 0
    
    # Horizontalni i vertikalni: svaka kombinacija 2 tacke daje 1 susret
    for count in iste_y_parnost_x.values():
        ukupno_pozdrava += count * (count - 1) // 2
        
    for count in iste_x_parnost_y.values():
        ukupno_pozdrava += count * (count - 1) // 2
        
    # Dijagonalni: svaka kombinacija 2 tacke na dijagonali daje 2 razlicita susreta
    # (npr. na x+y=C, jedan par je Sever-Istok, a drugi Jug-Zapad)
    for count in dijagonala_suma.values():
        ukupno_pozdrava += 2 * (count * (count - 1) // 2)
        
    for count in dijagonala_razlika.values():
        ukupno_pozdrava += 2 * (count * (count - 1) // 2)

    print(ukupno_pozdrava)

if __name__ == "__main__":
    resi_zadatak()